<?php
 

namespace app\providers;

class RouteServiceProvider extends \Illuminate\Foundation\Support\Providers\RouteServiceProvider
{
	protected $namespace = 'App\\Http\\Controllers';
    public const HOME = '/home';
	public function boot()
	{
		parent::boot();
	}

	public function map()
	{
		$this->mapApiRoutes();
		$this->mapWebRoutes();
	}

	protected function mapWebRoutes()
	{
		\Illuminate\Support\Facades\Route::middleware('web')->namespace($this->namespace)->group(base_path('routes/web.php'));
	}

	protected function mapApiRoutes()
	{
		\Illuminate\Support\Facades\Route::prefix('api')->middleware('api')->namespace($this->namespace)->group(base_path('routes/api.php'));
	}
}

?>