<?php

namespace App\Http\Controllers;

use Exception;
use App\Models\Order;
use App\Models\Reseller;
use App\Library\UddoktaPay;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class UddoktapayController extends Controller
{

    /**
     * Show the payment view
     *
     * @return void
     */
    public function show()
    {
        return view('uddoktapay.payment-form');
    }

    /**
     * Initializes the payment
     *
     * @param Request $request
     * @return void
     */
    public function pay(Request $request)
    {
        $validatedData = $request->validate([
            'full_name' => ['required', 'string'],
            'email'     => ['required', 'email'],
            'amount'    => ['required', 'integer'],
        ]);

        $order = Order::create([
            'full_name' => $validatedData['full_name'],
            'email'     => $validatedData['email'],
            'amount'    => $validatedData['amount'],
        ]);

        $requestData = [
            'full_name'    => $validatedData['full_name'],
            'email'        => $validatedData['email'],
            'amount'       => $validatedData['amount'],
            'metadata'     => [
                'order_id' => $order->id,
                'user_id'  => Auth::id(),
            ],
            'redirect_url'  => route('uddoktapay.success'),
            'return_type'   => 'GET',
            'cancel_url'    => route('uddoktapay.cancel'),
            'webhook_url'   => route('uddoktapay.webhook'),
        ];

        try {
            $paymentUrl = UddoktaPay::init_payment($requestData);
            return redirect($paymentUrl);
        } catch (Exception $e) {
            dd($e->getMessage());
        }
    }

    /**
     * Reponse from sever
     *
     * @param Request $request
     * @return void
     */
    public function webhook(Request $request)
    {

        $headerAPI = isset($_SERVER['HTTP_RT_UDDOKTAPAY_API_KEY']) ? $_SERVER['HTTP_RT_UDDOKTAPAY_API_KEY'] : NULL;

        if (empty($headerAPI)) {
            return response("Api key not found", 403);
        }

        if ($headerAPI != env("UDDOKTAPAY_API_KEY")) {
            return response("Unauthorized Action", 403);
        }

        $bodyContent = trim($request->getContent());
        $bodyData = json_decode($bodyContent);
        $data = UddoktaPay::verify_payment($bodyData->invoice_id);
        if (isset($data['status']) && $data['status'] == 'COMPLETED') {
            // Do action with $data
            $reseller = Reseller::firstWhere('user_id', $data['metadata']['user_id']);
            $reseller->balance += $data['amount'] / 100;
            $reseller->save();


            if ($reseller->client_id != null && $data['amount'] >= '500') {
                $reseller_master = Reseller::firstWhere('user_id', $reseller->client_id);
                $reseller_master->balance += $data['amount'] / 500;
                $reseller_master->save();
            }

            $order = Order::firstWhere('email', $data['email'])->latest()->first();
            $order->status = ($data['status'] == 'COMPLETED') ? 'Completed' : 'Pending';
            $order->payment_method = $data['payment_method'];
            $order->sender_number = $data['sender_number'];
            $order->transaction_id = $data['transaction_id'];
            $order->invoice_id = $data['invoice_id'];
            $order->save();
        }
    }

    /**
     * Success URL
     *
     * @return void
     */
    public function success(Request $request)
    {
        if (empty($request->invoice_id)) {
            die('Invalid Request');
        }
        $data = UddoktaPay::verify_payment($request->invoice_id);
        if (isset($data['status']) && $data['status'] == 'COMPLETED') {
            // do action with $data
            $reseller = Reseller::firstWhere('user_id', $data['metadata']['user_id']);
            $reseller->balance += $data['amount'] / 100;
            $reseller->save();


            if ($reseller->client_id != null && $data['amount'] >= '500') {
                $reseller_master = Reseller::firstWhere('user_id', $reseller->client_id);
                $reseller_master->balance += $data['amount'] / 500;
                $reseller_master->save();
            }

            $order = Order::firstWhere('email', $data['email'])->latest()->first();
            $order->status = ($data['status'] == 'COMPLETED') ? 'Completed' : 'Pending';
            $order->payment_method = $data['payment_method'];
            $order->sender_number = $data['sender_number'];
            $order->transaction_id = $data['transaction_id'];
            $order->invoice_id = $data['invoice_id'];
            $order->save();

            flash()->addSuccess($data['amount'] / 100 . '$' . ' Added Sucessfully');
            return back();
        } else {
            $order = Order::firstWhere('email', $data['email'])->latest()->first();
            $order->status = ($data['status'] == 'COMPLETED') ? 'Completed' : 'Pending';
            $order->payment_method = $data['payment_method'];
            $order->sender_number = $data['sender_number'];
            $order->transaction_id = $data['transaction_id'];
            $order->invoice_id = $data['invoice_id'];
            $order->save();
            // pending payment
            flash()->addError('Payment Still in pending, contact support as soon as possible');
            return back();
        }
    }

    /**
     * Cancel URL
     *
     * @return void
     */
    public function cancel()
    {
        flash()->addError('Payment is cancelled');
        return back();
    }
}
