<?php

namespace App\Http\Controllers;

use DGvai\SSLCommerz\SSLCommerz;
use App\Models\User;
use App\Models\Order;
use App\Models\Reseller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Log;
use Exception;

class SSLCommerzController extends Controller
{
    /**
     * Show the SSLCommerz payment view
     *
     * @return void
     */
    public function sshow()
    {
        return view('sslcommerz.payment-form');
    }

    /**
     * Initializes the SSLCommerz payment
     *
     * @param Request $request
     * @return void
     */
    public function spay(Request $request)
    {
        try {
            $validatedData = $request->validate([
                'full_name' => ['required', 'string'],
                'email'     => ['required', 'email'],
                'amount'    => ['required', 'numeric'],
            ]);
    
            // Generate a unique transaction_id
            $transactionId = 'LHQ' . strtoupper(Str::random(6));
    
            $order = Order::create([
                'full_name'      => $validatedData['full_name'],
                'email'          => $validatedData['email'],
                'amount'         => $validatedData['amount'],
                'transaction_id' => $transactionId,
            ]);
            $order->user_id = Auth::id();
            $order->save();
            $sslc = new SSLCommerz();
    
            $sslc->amount($validatedData['amount'])
                ->trxid($transactionId) // Use transaction_id as trxid
                ->product('Web Hosting')
                ->customer($validatedData['full_name'], $validatedData['email']);
    
            return $sslc->make_payment();
        } catch (\Exception $e) {
            // Log or handle any unexpected exceptions
            \Log::error('Exception in spay function: ' . $e->getMessage());
            flash()->addError('An error occurred. Please try again later.');
            return redirect()->route('uddoktapay.payment-form');
        }
    }
    
    
    
    

    /**
     * Response from SSLCommerz server
     *
     * @param Request $request
     * @return void
     */
    public function ssuccess(Request $request)
    {
        try {
            $validate = SSLCommerz::validate_payment($request);
    
            if (!$validate) {
                // Log or handle payment verification failure
                \Log::error('Payment verification failed');
                flash()->addError('Payment verification failed');
                return redirect()->route('uddoktapay.payment-form');
            }
    
            // Retrieve the correct transaction ID directly from the request
            $sslCommerzTransactionId = $request->tran_id;
    
            if (empty($sslCommerzTransactionId)) {
                // Log an error and return
                \Log::error('Transaction ID from SSLCommerz is empty.');
                flash()->addError('Transaction ID from SSLCommerz is empty.');
                return redirect()->route('uddoktapay.payment-form');
            }
    
            $order = Order::where('transaction_id', $sslCommerzTransactionId)->first();
    
            if ($order) {
                // Correctly retrieve user_id from the order
                $userId = $order->user_id;
    
                $reseller = Reseller::firstWhere('user_id', $userId);
    
                if ($reseller) {
                    $reseller->balance += $order->amount;
                    $reseller->save();
    
                    // Add your additional logic here for SSLCommerz success
    
                    // Update the order status to 'Completed'
                    $order->update([
                        'status' => 'Completed',
                        'payment_method' => 'Cards',
                        'transaction_id' => $sslCommerzTransactionId,
                    ]);
    
                    flash()->addSuccess($order->amount . '$' . ' Added Successfully');
                    return redirect()->route('uddoktapay.payment-form');
                } else {
                    // Log or handle reseller not found
                    \Log::error('Reseller not found for user_id: ' . $userId);
                }
            } else {
                // Log or handle order not found
                \Log::error('Order not found for transaction_id: ' . $sslCommerzTransactionId);
            }
    
            flash()->addError('Order not found');
            return redirect()->route('uddoktapay.payment-form');
        } catch (\Exception $e) {
            // Log or handle any unexpected exceptions
            \Log::error('Exception in ssuccess function: ' . $e->getMessage());
            flash()->addError('An error occurred. Please try again later.');
            return redirect()->route('uddoktapay.payment-form');
        }
    }
    
    
      
    /**
     * Failure URL
     *
     * @param Request $request
     * @return void
     */
    public function sfailure(Request $request)
    {
        // Do the database works for failure
        flash()->addError('Payment failed');
        return back();
    }

    /**
     * Cancel URL
     *
     * @return void
     */
    public function scancel()
    {
        flash()->addError('Payment is cancelled');
        return back();
    }
}
