<?php

namespace App\Http\Controllers;

use App\Models\Order;
use App\Models\User;
use App\Models\Reseller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CoinbasePaymentController extends Controller
{

    /**
     * Show the payment view
     *
     * @return void
     */
    // Pay: send the payment data to the coinbase and get payment url, addresses and id and other coinbase data's
    public function pay(Request $request)
    {

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => env('COINBASE_CHARGE_URL'),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS =>'{"name":"'.$request->full_name.'","description":"Deposit of $'.$request->amount.' to your account.","pricing_type":"fixed_price","local_price":{"currency":"usd","amount":"'.$request->amount.'"},"metadata":{"customer_name":"'.$request->full_name.'","customer_email":"'.$request->email.'"},"redirect_url":"'.env('APP_URL').'panel/coinbase/success/'.$request->email.'","cancel_url":"'.env('APP_URL').'panel/coinbase/failed/'.$request->email.'"}',
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
                'Accept: application/json',
                'X-CC-Version: '.env('COINBASE_XCC_VERSION'),
                'X-CC-Api-Key: '.env('COINBASE_XCC_KEY')
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);

        return $response;


    }

    //Store function stores the id and the order details before processed as Pending
    public function store(Request $request){
        Order::create([
            'full_name' => $request->full_name,
            'email'     => $request->email,
            'amount'    => $request->amount,
            'status'    => "Pending",
            'transaction_id'    => $request->transaction_id,
            'receipt_url'    => "",
            'payment_method'    => "COINBASE",
        ]);
        return 1;
    }

    //Success get and return success to the user and update the order to Completed and user balance
    public function success($email){
        $order = Order::firstWhere('email', $email)->latest()->first();
        $user = User::firstWhere('email', $email)->first();

        $reseller = Reseller::firstWhere('user_id', $user->id);
        $reseller->balance += $order->amount;
        $reseller->save();


        $order->status = "Completed";
        $order->save();

        flash()->addSuccess($order->amount . '$' . ' Added Sucessfully');
        return redirect()->route('uddoktapay.payment-form');
    }

    //Failed thats when payment failed, or canceled it's return to user with error failed and set the order as failed
    public function failed($email){
        $order = Order::firstWhere('email', Auth::user()->email)->latest()->first();
        $order->status = "Failed";
        $order->save();

        flash()->addError('Payment Failed!');
        return redirect()->route('uddoktapay.payment-form');
    }

}
