<?php

namespace App\Console\Commands;


use Carbon\Carbon;
use App\Models\User;
use App\Models\Reseller;
use Illuminate\Console\Command;
use App\Notifications\LicenseRenewalReminder;


class SendRenewalEmailsCommand extends Command
{
    protected $signature = 'emails:send-renewal';

    protected $description = 'Send Renewal Emails';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        $licenses = \App\License::where(function ($query) {
            $query->where('end_at', '>=', Carbon::now()->subDays(2))
                ->where('end_at', '<=', Carbon::now()->addDays(5));
        })
            ->where('type', 'Paid')
            ->get();

        foreach ($licenses as $license) {
            // Check if reseller exists before sending renewal email
            if ($license) {
                // Retrieve the user associated with the reseller
                $reseller = Reseller::firstWhere('id', $license->reseller_id);

                if ($reseller) {
                    $user = User::firstWhere('id', $reseller->user_id);

                    // Check if user exists before sending renewal email
                    if ($user) {
                        // Send renewal email to the user associated with this license
                        // You can use Laravel's built-in Mail facade or a third-party email service
                        $user->notify(new LicenseRenewalReminder($license));
                        sleep(120);
                    }
                }
            }
        }
    }
}
